import { blogPosts } from '@/data/blogData';
import { Products } from '@/data/staticProductData';
import { productCategories } from '@/data/productCategoriesData';

export const searchAll = (query) => {
  if (!query || query.trim() === '') return [];
  
  const searchTerm = query.toLowerCase().trim();
  
  // Search in blog posts
  const blogResults = blogPosts
    .filter(post => 
      post.title.toLowerCase().includes(searchTerm) || 
      (post.excerpt && post.excerpt.toLowerCase().includes(searchTerm)) ||
      (post.content && post.content.toLowerCase().includes(searchTerm))
    )
    .map(post => ({
      type: 'blog',
      id: post.id,
      title: post.title,
      excerpt: post.excerpt || '',
      url: `/blog/${post.slug}`,
      date: post.date
    }));

  // Search in products
  const productResults = Products
    .filter(product => 
      product.name.toLowerCase().includes(searchTerm) ||
      (product.description && product.description.toLowerCase().includes(searchTerm)) ||
      (product.category && product.category.toLowerCase().includes(searchTerm))
    )
    .map(product => ({
      type: 'product',
      id: product.id,
      name: product.name,
      category: product.category,
      price: product.price,
      image: product.images?.[0],
      url: `/product/${product.slug || product.id}`
    }));

  // Search in categories
  const categoryResults = productCategories
    .filter(category => 
      category.name.toLowerCase().includes(searchTerm) ||
      (category.description && category.description.toLowerCase().includes(searchTerm))
    )
    .map(category => ({
      type: 'category',
      id: category.id,
      name: category.name,
      description: category.description || '',
      url: `/products/${category.slug || category.id}`
    }));

  // Combine and limit results
  return [
    ...blogResults.slice(0, 3),
    ...productResults.slice(0, 3),
    ...categoryResults.slice(0, 2)
  ];
};

export const searchWithType = (type, query) => {
  if (!query || query.trim() === '') return [];
  
  const searchTerm = query.toLowerCase().trim();
  
  switch (type) {
    case 'blog':
      return blogData
        .filter(post => 
          post.title.toLowerCase().includes(searchTerm) || 
          (post.excerpt && post.excerpt.toLowerCase().includes(searchTerm))
        )
        .map(post => ({
          type: 'blog',
          id: post.id,
          title: post.title,
          excerpt: post.excerpt || '',
          url: `/blog/${post.slug}`,
          date: post.date
        }));

    case 'product':
      return products
        .filter(product => 
          product.name.toLowerCase().includes(searchTerm) ||
          (product.description && product.description.toLowerCase().includes(searchTerm))
        )
        .map(product => ({
          type: 'product',
          id: product.id,
          name: product.name,
          price: product.price,
          image: product.images?.[0],
          url: `/products/${product.slug || product.id}`
        }));

    case 'category':
      return categories
        .filter(category => 
          category.name.toLowerCase().includes(searchTerm) ||
          (category.description && category.description.toLowerCase().includes(searchTerm))
        )
        .map(category => ({
          type: 'category',
          id: category.id,
          name: category.name,
          description: category.description || '',
          url: `/products/category/${category.slug || category.id}`
        }));

    default:
      return [];
  }
};
