import { Products } from '@/data/staticProductData';


// Update featured products
export const featuredProducts = Products
    .filter(product => product.isFeatured)
    .slice(0, 6);



// Helper functions
export const getProductsByCategory = (categoryId) => {
    return Products.filter(product => product.category === categoryId);
};

export const getFeaturedProducts = () => {

    return Products;
}

export const getProductBySlug = (slug) => {
    return Products.find(product => product.slug === slug);
};

export const getProductById = (id) => {
    return Products.find(product => product.id === id);
};

export const getRelatedProducts = (product) => {
    return Products.filter(p => p.category === product.category && p.id !== product.id).slice(0, 4);
};
