import { blogPosts } from '@/data/blogData';

// Helper function to get a blog post by slug
export const getPostBySlug = async (slug) => {
    // Simulate API call with a small delay
    await new Promise(resolve => setTimeout(resolve, 0));
    return blogPosts.find(post => post.slug === slug) || null;
};

// Get all blog posts (for listing)
export const getAllPosts = async () => {
    // Simulate API call with a small delay
    await new Promise(resolve => setTimeout(resolve, 0));
    return blogPosts;
};

// Get related posts (excluding current post)
export const getRelatedPosts = async (currentPostId, limit = 2) => {
    // Simulate API call with a small delay
    await new Promise(resolve => setTimeout(resolve, 0));
    return blogPosts
        .filter(post => post.id !== currentPostId)
        .slice(0, limit);
};