/** @type {import('next-sitemap').IConfig} */
module.exports = {
  siteUrl: process.env.SITE_URL || 'https://i-technologybd.com/', // Update with your domain
  generateRobotsTxt: true, // Generate robots.txt
  generateIndexSitemap: true, // Generate index-sitemap.xml
  robotsTxtOptions: {
    policies: [
      {
        userAgent: '*',
        allow: '/',
      },
    ],
  },
  // Exclude any routes you don't want in the sitemap
  exclude: ['/server-sitemap.xml', '/admin/*', '/api/*'],
  // Add any additional paths that should be included in the sitemap
  // include: ['/special-page'],
}
