import Link from 'next/link';
import { ShoppingCart, Eye, Sparkles, ArrowRight } from 'lucide-react';
import Image from 'next/image';
export default function ProductCardV2({ product }) {
  // console.log(product);
  return (
    <div className="group relative">
      {/* Glow Effect */}
      <div className="absolute -inset-0.5 bg-gradient-to-r from-primary to-secondary rounded-3xl blur opacity-0 group-hover:opacity-30 transition duration-500"></div>

      {/* Card */}
      <div className="relative glass-white rounded-3xl overflow-hidden hover:shadow-2xl transition-all duration-500 transform group-hover:-translate-y-2">
        {/* Image Container with Overlay */}
        <div className="relative h-72 overflow-hidden bg-gradient-to-br from-gray-100 to-gray-200">
          <Image
            src={product.image || product.images[0]}
            alt={product.name}
            className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
            width={500}
            height={500}
          />

          {/* Gradient Overlay */}
          <div className="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>

          {/* Badge */}
          {product.badge && (
            <div className="absolute top-4 right-4 glass-dark px-4 py-2 rounded-full flex items-center gap-2">
              <Sparkles size={14} className="text-secondary animate-pulse" />
              <span className="text-white text-xs font-bold" style={{ fontFamily: 'Poppins, sans-serif' }}>
                {product.badge}
              </span>
            </div>
          )}

          {/* Hover Actions */}
          <div className="absolute inset-0 flex items-center justify-center gap-3 opacity-0 group-hover:opacity-100 transition-all duration-500">
            <Link
              href={`/product/${product.slug}`}
              className="glass-white p-4 rounded-2xl hover:bg-white transition-all transform hover:scale-110"
              aria-label="View product"
            >
              <Eye size={22} className="text-primary" />
            </Link>

            {/* cart button */}
            {/* <button
              className="glass-white p-4 rounded-2xl hover:bg-white transition-all transform hover:scale-110"
              aria-label="Add to cart"
            >
              <ShoppingCart size={22} className="text-secondary" />
            </button> */}
          </div>
        </div>

        {/* Content */}
        <div className="p-6">
          {product.category && (
            <div className="inline-flex items-center gap-2 mb-3">
              <div className="w-2 h-2 rounded-full bg-gradient-to-r from-primary to-secondary"></div>
              <span className="text-xs text-secondary font-bold uppercase tracking-wider" style={{ fontFamily: 'Poppins, sans-serif' }}>
                {product.category}
              </span>
            </div>
          )}

          <h3
            className="text-xl font-bold text-gray-800 mb-3 line-clamp-2 group-hover:text-primary transition-colors"
            style={{ fontFamily: 'Poppins, sans-serif' }}
          >
            {product.name}
          </h3>

          <p className="text-gray-600 text-sm mb-5 line-clamp-2 leading-relaxed" style={{ fontFamily: 'Inter, sans-serif' }}>
            {product.description}
          </p>

          {/* Divider */}
          <div className="h-px bg-gradient-to-r from-transparent via-gray-300 to-transparent mb-5"></div>

          {/* Price and Action */}
          <div className="flex items-center justify-between">
            {product.price && !product.isPriceHide ? (
              <div>
                {product.oldPrice && (
                  <span className="text-gray-400 line-through text-sm mr-2" style={{ fontFamily: 'Inter, sans-serif' }}>
                    ${product.oldPrice}
                  </span>
                )}
                <div className="flex items-baseline gap-1">
                  <span className="text-primary font-black text-2xl" style={{ fontFamily: 'Poppins, sans-serif' }}>
                    ${product.price}
                  </span>
                </div>
              </div>
            ) : (
              <Link href="/contact" className="text-primary font-bold text-sm" style={{ fontFamily: 'Poppins, sans-serif' }}>
                Contact for Price
              </Link>
            )}

            <Link
              href={`/product/${product.slug}`}
              className="group/btn flex items-center gap-2 text-secondary font-bold text-sm hover:text-secondary-dark transition-all"
              style={{ fontFamily: 'Poppins, sans-serif' }}
            >
              <span>View</span>
              <ArrowRight size={16} className="group-hover/btn:translate-x-1 transition-transform" />
            </Link>
          </div>
        </div>

        {/* Bottom Accent */}
        <div className="h-1 bg-gradient-to-r from-primary via-secondary to-primary transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500"></div>
      </div>
    </div>
  );
}
