import {
  Lightbulb,
  Target,
  CheckCircle2,
  AlertTriangle,
  Sparkles,
  ArrowRight,
  Zap,
} from "lucide-react";
import { projects } from "@/lib/navigation";
import Link from "next/link";

export const metadata = {
  title: "Projects | Intelligent Technology",
  description:
    "Discover our successful projects and case studies showcasing innovative security and automation solutions.",
};

export default function ProjectsPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary via-primary-dark to-gray-900 text-white py-24 overflow-hidden">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSI2MCIgaGVpZ2h0PSI2MCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAxMCAwIEwgMTAgNjAgTSAwIDEwIEwgNjAgMTAgTSAyMCAwIEwgMjAgNjAgTSAwIDIwIEwgNjAgMjAgTSAzMCAwIEwgMzAgNjAgTSAwIDMwIEwgNjAgMzAgTSA0MCAwIEwgNDAgNjAgTSAwIDQwIEwgNjAgNDAgTSA1MCAwIEwgNTAgNjAgTSAwIDUwIEwgNjAgNTAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS13aWR0aD0iMSIvPjwvcGF0dGVybj48L2RlZnM+PHJlY3Qgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgZmlsbD0idXJsKCNncmlkKSIvPjwvc3ZnPg==')] opacity-10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <div className="inline-flex items-center gap-2 glass-white px-6 py-3 rounded-full mb-6">
              <Sparkles size={20} className="text-secondary animate-pulse" />
              <span
                className="text-primary font-bold"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Our Work
              </span>
            </div>
            <h1
              className="text-5xl md:text-6xl lg:text-7xl font-black mb-6 leading-tight"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Our Projects
            </h1>
            <p
              className="text-xl md:text-2xl text-gray-200 leading-relaxed"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Delivering innovative solutions that transform industries
            </p>
          </div>
        </div>
        <div className="absolute bottom-0 left-0 right-0 h-20 bg-gradient-to-t from-gray-50 to-transparent"></div>
      </section>

      {/* Stats Section */}
      <section className="py-16 -mt-10 relative z-10">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-5xl mx-auto">
            <div className="glass-white p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
              <div
                className="text-4xl font-black text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                50+
              </div>
              <div
                className="text-sm text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Projects Completed
              </div>
            </div>
            <div className="glass-white p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
              <div
                className="text-4xl font-black text-secondary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                100%
              </div>
              <div
                className="text-sm text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Client Satisfaction
              </div>
            </div>
            <div className="glass-white p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
              <div
                className="text-4xl font-black text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                5+
              </div>
              <div
                className="text-sm text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Years Experience
              </div>
            </div>
            <div className="glass-white p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
              <div
                className="text-4xl font-black text-secondary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                24/7
              </div>
              <div
                className="text-sm text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Support Available
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Featured Projects */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2
              className="text-4xl md:text-5xl font-black mb-4 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Featured Projects
            </h2>
            <p
              className="text-xl text-gray-600 max-w-3xl mx-auto"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Showcasing our expertise in delivering cutting-edge technology
              solutions across diverse sectors
            </p>
          </div>

          <div className="space-y-8">
            {projects.map((project, index) => (
              <div
                key={index}
                className="glass-card rounded-3xl overflow-hidden hover:shadow-2xl transition-all group"
              >
                <div className="grid md:grid-cols-12 gap-8 p-8 md:p-10">
                  {/* Project Number Badge */}
                  <div className="md:col-span-2 flex md:flex-col items-center md:items-start gap-4">
                    <div className="relative">
                      <div className="w-20 h-20 bg-gradient-to-br from-primary to-secondary rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform">
                        <span
                          className="text-3xl font-black text-white"
                          style={{ fontFamily: "Poppins, sans-serif" }}
                        >
                          {String(index + 1).padStart(2, "0")}
                        </span>
                      </div>
                      <div className="absolute -inset-2 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-opacity -z-10"></div>
                    </div>
                  </div>

                  {/* Project Content */}
                  <div className="md:col-span-10 space-y-6">
                    {/* Title */}
                    <div>
                      <h3
                        className="text-2xl md:text-3xl font-black text-primary mb-3 group-hover:text-secondary transition-colors"
                        style={{ fontFamily: "Poppins, sans-serif" }}
                      >
                        {project.title}
                      </h3>
                      <div className="h-1 w-20 bg-gradient-to-r from-secondary to-secondary-light rounded-full group-hover:w-32 transition-all"></div>
                    </div>

                    {/* Description */}
                    <div className="flex items-start gap-3">
                      <Lightbulb
                        className="text-secondary mt-1 flex-shrink-0"
                        size={24}
                      />
                      <div>
                        <h4
                          className="font-bold text-primary mb-2"
                          style={{ fontFamily: "Poppins, sans-serif" }}
                        >
                          Project Overview
                        </h4>
                        <p
                          className="text-gray-700 text-lg leading-relaxed"
                          style={{ fontFamily: "Inter, sans-serif" }}
                        >
                          {project.description}
                        </p>
                      </div>
                    </div>

                    {/* Challenges */}
                    <div className="flex items-start gap-3">
                      <AlertTriangle
                        className="text-orange-500 mt-1 flex-shrink-0"
                        size={24}
                      />
                      <div>
                        <h4
                          className="font-bold text-primary mb-2"
                          style={{ fontFamily: "Poppins, sans-serif" }}
                        >
                          Challenges
                        </h4>
                        <p
                          className="text-gray-700 leading-relaxed"
                          style={{ fontFamily: "Inter, sans-serif" }}
                        >
                          {project.challenges}
                        </p>
                      </div>
                    </div>

                    {/* Outcome */}
                    <div className="flex items-start gap-3">
                      <CheckCircle2
                        className="text-green-600 mt-1 flex-shrink-0"
                        size={24}
                      />
                      <div>
                        <h4
                          className="font-bold text-primary mb-2"
                          style={{ fontFamily: "Poppins, sans-serif" }}
                        >
                          Outcome
                        </h4>
                        <p
                          className="text-gray-700 leading-relaxed"
                          style={{ fontFamily: "Inter, sans-serif" }}
                        >
                          {project.outcome}
                        </p>
                      </div>
                    </div>

                    {/* Tags */}
                    <div className="flex flex-wrap gap-2 pt-4">
                      {index === 0 && (
                        <>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Interactive Design
                          </span>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Museum Technology
                          </span>
                        </>
                      )}
                      {index === 1 && (
                        <>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Motion Sensors
                          </span>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Projection Mapping
                          </span>
                        </>
                      )}
                      {index === 2 && (
                        <>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Scale Modeling
                          </span>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Educational Display
                          </span>
                        </>
                      )}
                      {index === 3 && (
                        <>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Biometric Systems
                          </span>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Cloud Integration
                          </span>
                        </>
                      )}
                      {index === 4 && (
                        <>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            CCTV Surveillance
                          </span>
                          <span className="glass-white px-4 py-2 rounded-full text-sm font-semibold text-primary">
                            Power Grid Security
                          </span>
                        </>
                      )}
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Project Categories */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2
              className="text-4xl md:text-5xl font-black mb-4 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Our Expertise
            </h2>
            <p
              className="text-xl text-gray-600"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Specialized solutions across multiple domains
            </p>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 text-center">
              <div className="bg-gradient-to-br from-primary to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                <Target className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Museum Technology
              </h3>
              <p
                className="text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Interactive exhibits and displays
              </p>
            </div>
            <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 text-center">
              <div className="bg-gradient-to-br from-secondary to-secondary-light w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                <Zap className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Biometric Systems
              </h3>
              <p
                className="text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Attendance and access control
              </p>
            </div>
            <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 text-center">
              <div className="bg-gradient-to-br from-primary to-primary-light w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                <CheckCircle2 className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Surveillance Systems
              </h3>
              <p
                className="text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                CCTV and security solutions
              </p>
            </div>
            <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 text-center">
              <div className="bg-gradient-to-br from-secondary-dark to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                <Lightbulb className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Smart Integration
              </h3>
              <p
                className="text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                IoT and automation systems
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="glass-card p-12 rounded-3xl text-center max-w-4xl mx-auto relative overflow-hidden">
            <div className="absolute top-0 right-0 w-64 h-64 bg-gradient-to-br from-primary/10 to-secondary/10 rounded-full blur-3xl -z-10"></div>
            <div className="absolute bottom-0 left-0 w-64 h-64 bg-gradient-to-tr from-secondary/10 to-primary/10 rounded-full blur-3xl -z-10"></div>
            <Sparkles className="text-secondary mx-auto mb-6" size={64} />
            <h2
              className="text-4xl md:text-5xl font-black mb-6 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Have a Project in Mind?
            </h2>
            <p
              className="text-xl text-gray-700 mb-8 max-w-2xl mx-auto"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Let&apos;s collaborate to bring your vision to life with
              innovative technology solutions
            </p>
            <Link
              href="/contact"
              className="inline-flex items-center gap-3 bg-gradient-to-r from-secondary to-secondary-light text-white px-10 py-5 rounded-xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105 group"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              <span>Start Your Project</span>
              <ArrowRight
                size={24}
                className="group-hover:translate-x-1 transition-transform"
              />
            </Link>
          </div>
        </div>
      </section>
    </div>
  );
}
