import { getFeaturedProducts } from "@/queries/productQueries";
import ProductCard from "@/components/ProductCard";

import BrowseByCategories from "./_components/BrowseByCategories";

export const metadata = {
  title: "Products | Intelligent Technology",
  description:
    "Browse our comprehensive range of security systems, surveillance, access control, and office automation solutions.",
};

export default function ProductsPage() {
  const featuredProducts = getFeaturedProducts();

  return (
    <div className="min-h-screen bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        {/* Hero Section */}
        <div className="text-center mb-12">
          <h1 className="text-4xl font-extrabold text-primary sm:text-5xl sm:tracking-tight lg:text-6xl">
            Our Products
          </h1>
          <p className="mt-3 max-w-2xl mx-auto text-xl text-gray-500 sm:mt-4">
            Discover our comprehensive range of security and office automation
            solutions
          </p>
        </div>

        {/* Featured Products */}
        <div className="mb-16">
          {/* <div className="flex justify-between items-center mb-6">
            <h2 className="text-2xl font-bold text-gray-900">Featured Products</h2>
            <Link href="/products/all" className="text-indigo-600 hover:text-indigo-500 font-medium">
              View all products <span aria-hidden="true">&rarr;</span>
            </Link>
          </div> */}

          <div className="grid grid-cols-1 gap-y-10 gap-x-6 sm:grid-cols-2 lg:grid-cols-3 xl:gap-x-8">
            {featuredProducts.map((product) => (
              <ProductCard key={product.id} product={product} />
            ))}
          </div>
        </div>

        {/* Categories */}
       <BrowseByCategories />
      </div>
    </div>
  );
}
