import React from "react";
import { productCategories } from "@/data/productCategoriesData";
import Link from "next/link";
import { ArrowRight } from "lucide-react";
const BrowseByCategories = () => {
  return (
    <div>
      <h2 className="text-2xl font-bold text-gray-900 mb-6">
        Browse by Category
      </h2>
      <div className="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
        {productCategories.map((category) => (
          <Link
            key={category.id}
            href={`/products/${category.id}`}
            className="group relative bg-white border border-gray-200 rounded-lg p-6 focus-within:ring-2 focus-within:ring-primary/50 focus-within:ring-offset-2 hover:border-primary/30 hover:shadow-lg transition-all duration-300"
          >
            <div>
              <span className="rounded-lg inline-flex p-3 bg-gradient-to-br from-primary/10 to-secondary/10 text-primary ring-4 ring-white group-hover:from-primary/20 group-hover:to-secondary/20 transition-all duration-300">
                <category.icon className="h-6 w-6" aria-hidden="true" />
              </span>
            </div>
            <div className="mt-8">
              <h3 className="text-lg font-medium text-gray-900 group-hover:text-primary transition-colors">
                <span className="absolute inset-0" aria-hidden="true" />
                {category.name}
              </h3>
              <p className="mt-2 text-sm text-gray-500">
                {category.description}
              </p>
            </div>
            <span
              className="pointer-events-none absolute top-6 right-6 text-gray-300 group-hover:text-secondary transition-colors duration-300"
              aria-hidden="true"
            >
              <ArrowRight className="h-6 w-6" />
            </span>
          </Link>
        ))}
      </div>
    </div>
  );
};

export default BrowseByCategories;
