'use client';

import { Share2 } from 'lucide-react';
import { useState } from 'react';

export default function ShareButton() {
  const [isCopied, setIsCopied] = useState(false);

  const handleShare = async () => {
    try {
      await navigator.clipboard.writeText(window.location.href);
      setIsCopied(true);
      
      // Reset the copied state after 2 seconds
      setTimeout(() => {
        setIsCopied(false);
      }, 2000);
    } catch (err) {
      console.error('Failed to copy URL: ', err);
    }
  };

  return (
    <button 
      onClick={handleShare}
      className="p-3 border border-gray-300 rounded-lg hover:bg-gray-50 relative group cursor-pointer"
      aria-label="Share product"
      title="Copy link to clipboard"
    >
      <Share2 className="h-5 w-5 text-gray-600" />
      <span className={`absolute -top-8 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-2 py-1 rounded whitespace-nowrap transition-opacity duration-200 ${isCopied ? 'opacity-100' : 'opacity-0 pointer-events-none'}`}>
        Link copied!
      </span>
    </button>
  );
}
