"use client";

// COMPONENTS
import Hero from "@/components/Hero";
import AboutUsSection from "@/app/_components/AboutUsSection";
import WhyChooseUsSection from "./_components/WhyChooseUsSection";
import ProductsAndSolutionsSection from "./_components/ProductsAndSolutionsSection";
import CTASection from "@/app/_components/CTASection";
import BrandsSection from "./_components/BrandsSection";
import LatestProductsSection from "./_components/LatestProductsSection";
import BlogsAndNewsSection from "./_components/BlogsAndNewsSection";
import BranchesSection from "./_components/BranchesSection";
import {
  FadeIn,
  SlideInLeft,
  SlideInRight,
  ScaleIn,
} from "@/components/AnimationWrappers";

export default function Home() {
  return (
    <div
      className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-50"
      style={{ fontFamily: "Inter, sans-serif" }}
    >
      <Hero />

      {/* About Us Section */}
      <FadeIn>
        <AboutUsSection />
      </FadeIn>

      {/* Why Choose Us */}
      <FadeIn>
        <WhyChooseUsSection />
      </FadeIn>

      {/* Products & Solutions */}
      <FadeIn>
        <ProductsAndSolutionsSection />
      </FadeIn>

      {/* CTA Get Started */}
      <FadeIn>
        <CTASection />
      </FadeIn>

      {/* Brands */}
      <FadeIn>
        <BrandsSection />
      </FadeIn>

      {/* Latest Products */}

      <LatestProductsSection />

      {/* Blog & News */}
      <FadeIn>
        <BlogsAndNewsSection />
      </FadeIn>

      {/* Our Branches */}
      <FadeIn>
        <BranchesSection />
      </FadeIn>
    </div>
  );
}
