import Link from 'next/link';

export default function NotFound() {
  return (
    <div className="min-h-[calc(100vh-200px)] flex flex-col items-center justify-center text-center px-4 py-16 bg-gray-50 pt-50">
      <div className="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md">
        <div className="text-8xl font-bold text-gray-300 mb-4">404</div>
        <h1 className="text-3xl font-semibold text-gray-800 mb-4">Page Not Found</h1>
        <p className="text-lg text-gray-800 mb-8">
          The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.
        </p>
        
        <div className="space-y-4">
          <Link
            href="/"
            className="inline-block w-full sm:w-auto px-8 py-3 text-base font-medium text-white bg-primary hover:bg-secondary rounded-md transition-colors duration-200"
          >
            Go to Homepage
          </Link>
          
          <div className="text-sm text-gray-500 mt-6">
            Need help? <a href="/contact" className="text-blue-600 hover:underline">Contact our support</a>
          </div>
        </div>
      </div>
    </div>
  );
}
