import "./globals.css";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import { Suspense } from "react";
import LoadingOverlay from "@/components/LoadingOverlay";
import PageTransition from "@/components/PageTransition";

const siteUrl = "https://i-technologybd.com";

export const metadata = {
  title: "Intelligent Technology | Security & Automation Solutions",
  description:
    "Leading provider of innovative technology solutions in Bangladesh. Intelligent Technology specializes in card printing, office automation, security systems, surveillance, and access control solutions with a commitment to excellence.",
  keywords:
    "security systems, automation, surveillance, access control, card printing, office automation, Intelligent Technology, Bangladesh, enterprise solutions, CCTV, biometric systems",
  authors: [{ name: "Intelligent Technology" }],
  creator: "Intelligent Technology",
  icons: {
    icon: "/logo-transparent.png",
  },
  openGraph: {
    title: "Intelligent Technology | Security & Automation Solutions",
    description:
      "Leading provider of innovative technology solutions in Bangladesh. Specializing in card printing, office automation, security systems, and surveillance solutions for businesses.",
    url: siteUrl,
    siteName: "Intelligent Technology",
    images: [
      {
        url: `${siteUrl}/logo.png`,
        width: 1200,
        height: 630,
        alt: "Intelligent Technology Logo",
      },
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Intelligent Technology | Security & Automation Solutions",
    description:
      "Leading provider of innovative technology solutions in Bangladesh. Specializing in card printing, office automation, and security solutions.",
    images: [`${siteUrl}/logo.png`],
    creator: "@inteltech",
  },
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body cz-shortcut-listen="true">
        <Header />
        <LoadingOverlay>
          <PageTransition>
            <main className="mt-24 md:mt-[170px]">{children}</main>
          </PageTransition>
        </LoadingOverlay>
        <Footer />
      </body>
    </html>
  );
}
