import {
  Phone,
  Mail,
  MapPin,
  Clock,
  Send,
  Facebook,
  Linkedin,
  Building2,
  Sparkles,
  CheckCircle2,
} from "lucide-react";
import { contactInfo, branches, socialLinks } from "@/lib/navigation";
import PageHeroSection from "@/components/PageHeroSection";
import ContactForm from "./ContactForm";

export const metadata = {
  title: "Contact Us | Intelligent Technology",
  description:
    "Get in touch with Intelligent Technology. Contact us for inquiries about our security systems, automation solutions, and enterprise products.",
};

export default function ContactPage() {
  const getSocialIcon = (iconName) => {
    switch (iconName) {
      case "facebook":
        return <Facebook size={24} />;
      case "linkedin":
        return <Linkedin size={24} />;
      default:
        return null;
    }
  };

  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100 ">
      {/* Hero Section */}
      <PageHeroSection
        pageName="Contact Us"
        pageDescription="We're here to help you with your technology needs"
      />
      {/* Contact Information Cards */}
      <section className="py-16 -mt-10 relative z-10">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-3 gap-0.5 md:gap-6 max-w-5xl mx-auto">
            <a
              href={`tel:${contactInfo.phone}`}
              className="glass-white p-2 md:p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 group text-center"
            >
              <div className="bg-gradient-to-br from-secondary to-secondary-light w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                <Phone className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Call Us
              </h3>
              <p
                className="text-gray-700 font-semibold"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                {contactInfo.phone}
              </p>
            </a>

            <a
              href={`mailto:${contactInfo.email}`}
              className="glass-white p-2 md:p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 group text-center"
            >
              <div className="bg-gradient-to-br from-primary to-primary-light w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                <Mail className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Email Us
              </h3>
              <p
                className="text-gray-700 font-semibold break-all"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                {contactInfo.email}
              </p>
            </a>

            <div className="glass-white p-2 md:p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 group text-center">
              <div className="bg-gradient-to-br from-secondary-dark to-secondary w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                <MapPin className="text-white" size={32} />
              </div>
              <h3
                className="text-xl font-bold text-primary mb-2"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Visit Us
              </h3>
              <p
                className="text-gray-700 font-semibold"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                {contactInfo.address}
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Main Content Grid */}
      <section className="md:py-20 py-8">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12">
            {/* Contact Form */}
            <ContactForm />

            {/* Office Information */}
            <div className="space-y-8">
              {/* Office Details */}
              <div className="glass-card p-8 rounded-3xl">
                <div className="flex items-center gap-3 mb-6">
                  <Building2 className="text-secondary" size={32} />
                  <h2
                    className="text-3xl font-black text-primary"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    Our Office
                  </h2>
                </div>
                {branches.map((branch, index) => (
                  <div key={index} className="space-y-4">
                    <h3
                      className="text-xl font-bold text-primary"
                      style={{ fontFamily: "Poppins, sans-serif" }}
                    >
                      {branch.name}
                    </h3>
                    <div
                      className="space-y-3 text-gray-700"
                      style={{ fontFamily: "Inter, sans-serif" }}
                    >
                      <div className="flex items-start gap-3">
                        <MapPin
                          className="text-secondary mt-1 flex-shrink-0"
                          size={20}
                        />
                        <p>{branch.address}</p>
                      </div>
                      <div className="flex items-center gap-3">
                        <Phone
                          className="text-secondary flex-shrink-0"
                          size={20}
                        />
                        <a
                          href={`tel:${branch.phone}`}
                          className="hover:text-primary transition-colors"
                        >
                          {branch.phone}
                        </a>
                      </div>
                      <div className="flex items-center gap-3">
                        <Mail
                          className="text-secondary flex-shrink-0"
                          size={20}
                        />
                        <a
                          href={`mailto:${branch.email}`}
                          className="hover:text-primary transition-colors break-all"
                        >
                          {branch.email}
                        </a>
                      </div>
                    </div>
                  </div>
                ))}
              </div>

              {/* Business Hours */}
              <div className="glass-card p-8 rounded-3xl">
                <div className="flex items-center gap-3 mb-6">
                  <Clock className="text-secondary" size={32} />
                  <h2
                    className="text-3xl font-black text-primary"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    Business Hours
                  </h2>
                </div>
                <div
                  className="space-y-3 text-gray-700"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  <div className="flex justify-between items-center py-2 border-b border-gray-200">
                    <span className="font-semibold">Saturday - Thursday</span>
                    <span>9:00 AM - 6:00 PM</span>
                  </div>
                  <div className="flex justify-between items-center py-2 border-b border-gray-200">
                    <span className="font-semibold">Friday</span>
                    <span className="text-red-600 font-semibold">Closed</span>
                  </div>
                  <div className="glass-white p-4 rounded-xl mt-4">
                    <p className="text-sm">
                      <strong className="text-primary">
                        Customer Support:
                      </strong>{" "}
                      Available 8 hours/day, 6 days/week
                    </p>
                  </div>
                </div>
              </div>

              {/* Social Media */}
              <div className="glass-card p-8 rounded-3xl">
                <h2
                  className="text-3xl font-black text-primary mb-6"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Connect With Us
                </h2>
                <div className="flex gap-4">
                  {socialLinks.map((social, index) => (
                    <a
                      key={social.url}
                      href={social.url}
                      target="_blank"
                      rel="noopener noreferrer"
                      className="bg-gradient-to-br from-primary to-secondary text-white w-14 h-14 rounded-xl flex items-center justify-center hover:shadow-2xl transition-all hover:scale-110"
                      aria-label={social.name}
                    >
                      {getSocialIcon(social.label.toLowerCase())}
                    </a>
                  ))}
                </div>
                <div
                  className="mt-6 space-y-2 text-sm text-gray-600"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  <p>Follow us for updates, news, and insights</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Google Maps */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2
              className="text-4xl md:text-5xl font-black mb-4 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Find Us on Map
            </h2>
            <p
              className="text-xl text-gray-600"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Visit our office in Mirpur-10, Dhaka
            </p>
          </div>
          <div className="glass-white p-4 rounded-3xl overflow-hidden max-w-6xl mx-auto">
            <div className="relative w-full h-[500px] rounded-2xl overflow-hidden">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3650.0976544847456!2d90.36812931543654!3d23.806720492577!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c0d6f6b8e8e1%3A0x6c3e9c5e5e5e5e5e!2sMirpur-10%2C%20Dhaka!5e0!3m2!1sen!2sbd!4v1234567890123!5m2!1sen!2sbd"
                width="100%"
                height="100%"
                style={{ border: 0 }}
                allowFullScreen=""
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
                title="Intelligent Technology Office Location"
                className="rounded-2xl"
              ></iframe>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="glass-card p-12 rounded-3xl text-center max-w-4xl mx-auto">
            <Sparkles className="text-secondary mx-auto mb-6" size={64} />
            <h2
              className="text-4xl md:text-5xl font-black mb-6 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Ready to Get Started?
            </h2>
            <p
              className="text-xl text-gray-700 mb-8"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              Contact us today and let&apos;s discuss how we can help transform
              your business with innovative technology solutions
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href={`tel:${contactInfo.phone}`}
                className="inline-flex items-center gap-3 bg-gradient-to-r from-secondary to-secondary-light text-white px-8 py-4 rounded-xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                <Phone size={24} />
                <span>Call Now</span>
              </a>
              <a
                href={`mailto:${contactInfo.email}`}
                className="inline-flex items-center gap-3 glass-white text-primary px-8 py-4 rounded-xl font-bold text-lg hover:shadow-xl transition-all hover:scale-105 border-2 border-primary/20"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                <Mail size={24} />
                <span>Email Us</span>
              </a>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}
