"use client";

import { useState } from "react";
import { Send, CheckCircle2 } from "lucide-react";
const ContactForm = () => {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    phone: "",
    subject: "",
    message: "",
  });

  const [submitted, setSubmitted] = useState(false);

  const handleChange = (e) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value,
    });
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    // Handle form submission logic here
    // console.log('Form submitted:', formData);
    setSubmitted(true);
    setTimeout(() => setSubmitted(false), 3000);
  };
  return (
    <div className="glass-card p-8 md:p-10 rounded-3xl">
      <h2
        className="text-3xl md:text-4xl font-black mb-6 gradient-text"
        style={{ fontFamily: "Poppins, sans-serif" }}
      >
        Send Us a Message
      </h2>
      <form onSubmit={handleSubmit} className="space-y-6">
        <div>
          <label
            htmlFor="name"
            className="block text-sm font-semibold text-primary mb-2"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Full Name *
          </label>
          <input
            type="text"
            id="name"
            name="name"
            value={formData.name}
            onChange={handleChange}
            required
            className="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/20 transition-all"
            style={{ fontFamily: "Inter, sans-serif" }}
            placeholder="Enter your full name"
          />
        </div>

        <div className="grid md:grid-cols-2 gap-6">
          <div>
            <label
              htmlFor="email"
              className="block text-sm font-semibold text-primary mb-2"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Email Address *
            </label>
            <input
              type="email"
              id="email"
              name="email"
              value={formData.email}
              onChange={handleChange}
              required
              className="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/20 transition-all"
              style={{ fontFamily: "Inter, sans-serif" }}
              placeholder="your@email.com"
            />
          </div>

          <div>
            <label
              htmlFor="phone"
              className="block text-sm font-semibold text-primary mb-2"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Phone Number
            </label>
            <input
              type="tel"
              id="phone"
              name="phone"
              value={formData.phone}
              onChange={handleChange}
              className="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/20 transition-all"
              style={{ fontFamily: "Inter, sans-serif" }}
              placeholder="+880 1234-567890"
            />
          </div>
        </div>

        <div>
          <label
            htmlFor="subject"
            className="block text-sm font-semibold text-primary mb-2"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Subject *
          </label>
          <input
            type="text"
            id="subject"
            name="subject"
            value={formData.subject}
            onChange={handleChange}
            required
            className="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/20 transition-all"
            style={{ fontFamily: "Inter, sans-serif" }}
            placeholder="How can we help you?"
          />
        </div>

        <div>
          <label
            htmlFor="message"
            className="block text-sm font-semibold text-primary mb-2"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Message *
          </label>
          <textarea
            id="message"
            name="message"
            value={formData.message}
            onChange={handleChange}
            required
            rows="6"
            className="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-primary focus:ring-2 focus:ring-primary/20 transition-all resize-none"
            style={{ fontFamily: "Inter, sans-serif" }}
            placeholder="Tell us more about your requirements..."
          ></textarea>
        </div>

        <button
          type="submit"
          className="w-full bg-gradient-to-r from-secondary to-secondary-light text-white px-8 py-4 rounded-xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105 flex items-center justify-center gap-3 group"
          style={{ fontFamily: "Poppins, sans-serif" }}
        >
          {submitted ? (
            <>
              <CheckCircle2 size={24} />
              <span>Message Sent!</span>
            </>
          ) : (
            <>
              <span>Send Message</span>
              <Send
                size={24}
                className="group-hover:translate-x-1 transition-transform"
              />
            </>
          )}
        </button>
      </form>
    </div>
  );
};

export default ContactForm;
