

export async function generateMetadata({ params }) {
  // For the main blog page
  if (!params?.slug) {
    return {
      title: 'Blog | Intelligent Technology',
      description: 'Latest insights, news, and updates from Intelligent Technology',
      openGraph: {
        title: 'Blog | Intelligent Technology',
        description: 'Latest insights, news, and updates from Intelligent Technology',
        url: 'https://i-technologybd.com/blog',
        siteName: 'Intelligent Technology',
        locale: 'en_US',
        type: 'website',
      },
      twitter: {
        card: 'summary_large_image',
        title: 'Blog | Intelligent Technology',
        description: 'Latest insights, news, and updates from Intelligent Technology',
      },
    };
  }

  // For individual blog posts
  const { slug } = params;
  const post = await getPostBySlug(slug);

  if (!post) {
    return {
      title: 'Post Not Found | Intelligent Technology',
      description: 'The requested blog post could not be found.',
    };
  }

  const siteUrl = process.env.NEXT_PUBLIC_SITE_URL || 'https://i-technologybd.com';
  const postUrl = `${siteUrl}/blog/${slug}`;

  return {
    title: `${post.title} | Intelligent Technology Blog`,
    description: post.excerpt,
    keywords: [
      ...post.tags || [],
      post.category,
      'Intelligent Technology',
      'Blog',
    ].filter(Boolean).join(', '),

    // Open Graph / Facebook
    openGraph: {
      title: `${post.title} | Intelligent Technology Blog`,
      description: post.excerpt,
      url: postUrl,
      siteName: 'Intelligent Technology',
      images: [
        {
          url: post.image,
          width: 1200,
          height: 630,
          alt: post.title,
        },
      ],
      locale: 'en_US',
      type: 'article',
      publishedTime: new Date(post.date).toISOString(),
      authors: [post.author?.name || 'Intelligent Technology'],
    },

    // Twitter
    twitter: {
      card: 'summary_large_image',
      title: `${post.title} | Intelligent Technology Blog`,
      description: post.excerpt,
      images: [post.image],
      creator: '@inteltech',
    },
  };
}

export default function BlogLayout({ children }) {
  return (
    <>
      {children}
    </>
  );
}
