import {
  Building2,
  Award,
  Shield,
  Users,
  Target,
  Lightbulb,
  Phone,
  Mail,
  MapPin,
  CheckCircle2,
  Sparkles,
} from "lucide-react";
import { teamMembers } from "@/lib/navigation";
import Link from "next/link";
import Image from "next/image";
import PageHeroSection from "@/components/PageHeroSection";
import {
  FadeIn,
  SlideInLeft,
  SlideInRight,
  StaggerContainer,
  StaggerItem,
  ScaleIn,
} from "@/components/AnimationWrappers";
export const metadata = {
  title: "About Us | Intelligent Technology",
  description:
    "Learn more about Intelligent Technology and our commitment to excellence in card printing, office automation, and security solutions.",
};

export default function AboutPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100">
      {/* Hero Section */}
      <PageHeroSection
        pageName="About Us"
        pageDescription="Leading provider of innovative technology solutions in Bangladesh"
      />

      {/* Company Overview */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <SlideInLeft useInitial={true}>
              {/* Company Logo */}
              <div className="mb-8 flex justify-center md:justify-start">
                <div className="glass-card p-6 rounded-2xl inline-block">
                  <Image
                    src="/logo.png"
                    alt="Intelligent Technology Logo"
                    width={180}
                    height={80}
                    className="object-contain"
                    priority
                  />
                </div>
              </div>

              <h2
                className="text-4xl md:text-5xl font-black mb-6 gradient-text"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Who We Are
              </h2>
              <div
                className="space-y-4 text-gray-700"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                <p className="text-lg leading-relaxed">
                  <strong className="text-primary">
                    Intelligent Technology
                  </strong>{" "}
                  is a pioneering company in Bangladesh specializing in{" "}
                  <strong>
                    Card Printing, Office Automation & Security Solutions
                  </strong>
                  .
                </p>
                <div className="glass-card p-6 rounded-2xl space-y-3">
                  <div className="flex items-start gap-3">
                    <Building2
                      className="text-primary mt-1 flex-shrink-0"
                      size={24}
                    />
                    <div>
                      <p className="font-semibold text-primary">Industry</p>
                      <p>
                        Card Printing, Office Automation & Security Solutions
                      </p>
                    </div>
                  </div>
                  <div className="flex items-start gap-3">
                    <MapPin
                      className="text-secondary mt-1 flex-shrink-0"
                      size={24}
                    />
                    <div>
                      <p className="font-semibold text-primary">Address</p>
                      <p>
                        House #7 (3rd Floor), Road #4, Mirpur-10, Dhaka-1216,
                        Bangladesh
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </SlideInLeft>

            <StaggerContainer
              className="grid grid-cols-2 gap-6"
              staggerDelay={0.1}
              useInitial={true}
            >
              <StaggerItem>
                <div className="glass-card p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
                  <Award className="text-secondary mx-auto mb-4" size={48} />
                  <h3
                    className="text-3xl font-bold text-primary mb-2"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    5+
                  </h3>
                  <p
                    className="text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    Years Experience
                  </p>
                </div>
              </StaggerItem>
              <StaggerItem>
                <div className="glass-card p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
                  <Users className="text-primary mx-auto mb-4" size={48} />
                  <h3
                    className="text-3xl font-bold text-primary mb-2"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    50+
                  </h3>
                  <p
                    className="text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    Happy Clients
                  </p>
                </div>
              </StaggerItem>
              <StaggerItem>
                <div className="glass-card p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
                  <Shield className="text-secondary mx-auto mb-4" size={48} />
                  <h3
                    className="text-3xl font-bold text-primary mb-2"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    24/7
                  </h3>
                  <p
                    className="text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    Support Desk
                  </p>
                </div>
              </StaggerItem>
              <StaggerItem>
                <div className="glass-card p-6 rounded-2xl text-center hover:shadow-2xl transition-all hover:scale-105">
                  <Lightbulb className="text-primary mx-auto mb-4" size={48} />
                  <h3
                    className="text-3xl font-bold text-primary mb-2"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    100%
                  </h3>
                  <p
                    className="text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    Quality Assured
                  </p>
                </div>
              </StaggerItem>
            </StaggerContainer>
          </div>
        </div>
      </section>

      {/* Partnerships & Certifications */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4">
          <FadeIn>
            <div className="text-center mb-12">
              <h2
                className="text-4xl md:text-5xl font-black mb-4 gradient-text"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Partnerships & Certifications
              </h2>
              <p
                className="text-xl text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Trusted by leading global brands
              </p>
            </div>
          </FadeIn>
          <StaggerContainer
            className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto"
            staggerDelay={0.15}
          >
            <StaggerItem>
              <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105">
                <Award className="text-secondary mb-4" size={40} />
                <h3
                  className="text-xl font-bold text-primary mb-2"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Authorized Distributor
                </h3>
                <p
                  className="text-gray-700"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  HiTi Digital Inc. (Taiwan)
                </p>
              </div>
            </StaggerItem>
            <StaggerItem>
              <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105">
                <Shield className="text-primary mb-4" size={40} />
                <h3
                  className="text-xl font-bold text-primary mb-2"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Authorized Reseller
                </h3>
                <p
                  className="text-gray-700"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  Zebra Technologies (USA)
                  <br />
                  Evolis Card Printers (France)
                </p>
              </div>
            </StaggerItem>
            <StaggerItem>
              <div className="glass-white p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105">
                <CheckCircle2 className="text-secondary mb-4" size={40} />
                <h3
                  className="text-xl font-bold text-primary mb-2"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Licensed & Certified
                </h3>
                <p
                  className="text-gray-700"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  Class-One Contractor
                  <br />
                  e-GP Enlisted
                  <br />
                  Electrical Supervisory License
                </p>
              </div>
            </StaggerItem>
          </StaggerContainer>
        </div>
      </section>

      {/* Vision & Mission */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="grid md:grid-cols-2 gap-12">
            <SlideInLeft delay={0.2}>
              <div className="glass-card p-10 rounded-3xl hover:shadow-2xl transition-all">
                <Target className="text-secondary mb-6" size={56} />
                <h2
                  className="text-3xl font-black mb-6 text-primary"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Company Vision
                </h2>
                <p
                  className="text-lg text-gray-700 leading-relaxed"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  To become the most trusted provider of innovative technology
                  solutions in Bangladesh by delivering world-class products and
                  services that ensure efficiency, security, and digital
                  transformation across all sectors.
                </p>
              </div>
            </SlideInLeft>
            <SlideInRight delay={0.2}>
              <div className="glass-card p-10 rounded-3xl hover:shadow-2xl transition-all">
                <Lightbulb className="text-primary mb-6" size={56} />
                <h2
                  className="text-3xl font-black mb-6 text-primary"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  Company Mission
                </h2>
                <ul
                  className="space-y-4 text-lg text-gray-700"
                  style={{ fontFamily: "Inter, sans-serif" }}
                >
                  <li className="flex items-start gap-3">
                    <CheckCircle2
                      className="text-secondary mt-1 flex-shrink-0"
                      size={20}
                    />
                    <span>
                      Empower organizations with cutting-edge automation and
                      security technologies
                    </span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle2
                      className="text-secondary mt-1 flex-shrink-0"
                      size={20}
                    />
                    <span>
                      Deliver reliable, high-quality products and services that
                      exceed customer expectations
                    </span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle2
                      className="text-secondary mt-1 flex-shrink-0"
                      size={20}
                    />
                    <span>
                      Build long-term relationships based on trust, innovation,
                      and service excellence
                    </span>
                  </li>
                  <li className="flex items-start gap-3">
                    <CheckCircle2
                      className="text-secondary mt-1 flex-shrink-0"
                      size={20}
                    />
                    <span>
                      Contribute to the nation&apos;s growth through sustainable
                      and smart technology solutions
                    </span>
                  </li>
                </ul>
              </div>
            </SlideInRight>
          </div>
        </div>
      </section>

      {/* CEO Quote */}
      <FadeIn>
        <section className="py-20 bg-gradient-to-br from-primary via-primary-dark to-gray-900 text-white relative overflow-hidden">
          <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgNDAgMTAgTSAxMCAwIEwgMTAgNDAgTSAwIDIwIEwgNDAgMjAgTSAyMCAwIEwgMjAgNDAgTSAwIDMwIEwgNDAgMzAgTSAzMCAwIEwgMzAgNDAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjAzIiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-30"></div>
          <div className="container mx-auto px-4 relative z-10">
            <div className="max-w-4xl mx-auto text-center">
              <div className="text-8xl text-secondary-light mb-6 opacity-50">
                &quot;
              </div>
              <blockquote
                className="text-2xl md:text-3xl font-medium mb-8 leading-relaxed"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                At Intelligent Technology, we believe technology should simplify
                life, strengthen security, and enhance productivity. Our mission
                is to deliver smart, efficient, and sustainable solutions that
                help our clients stay ahead in an ever-evolving digital world.
              </blockquote>
              <div className="glass-white inline-block px-8 py-4 rounded-2xl">
                <p
                  className="text-primary font-bold text-lg"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  — Management, Intelligent Technology
                </p>
              </div>
            </div>
          </div>
        </section>
      </FadeIn>

      {/* Team Members */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <FadeIn>
            <div className="text-center mb-12">
              <h2
                className="text-4xl md:text-5xl font-black mb-4 gradient-text"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Our Team
              </h2>
              <p
                className="text-xl text-gray-600"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Meet the experts behind our success
              </p>
            </div>
          </FadeIn>
          <StaggerContainer
            className="grid md:grid-cols-2 lg:grid-cols-3 gap-8"
            staggerDelay={0.1}
          >
            {teamMembers.map((member, index) => (
              <StaggerItem key={index}>
                <div className="glass-card p-8 rounded-2xl hover:shadow-2xl transition-all hover:scale-105 group">
                  <div className="bg-gradient-to-br from-primary to-secondary w-20 h-20 rounded-full flex items-center justify-center mb-6 mx-auto group-hover:scale-110 transition-transform">
                    <Users className="text-white" size={40} />
                  </div>
                  <h3
                    className="text-2xl font-bold text-primary mb-2 text-center"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    {member.name}
                  </h3>
                  <p
                    className="text-secondary font-semibold mb-4 text-center"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    {member.position}
                  </p>
                  <div
                    className="space-y-2 text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    <a
                      href={`tel:${member.contact}`}
                      className="flex items-center gap-3 hover:text-primary transition-colors"
                    >
                      <Phone size={18} className="text-secondary" />
                      <span>{member.contact}</span>
                    </a>
                    <a
                      href={`mailto:${member.email}`}
                      className="flex items-center gap-3 hover:text-primary transition-colors break-all"
                    >
                      <Mail size={18} className="text-secondary" />
                      <span>{member.email}</span>
                    </a>
                  </div>
                </div>
              </StaggerItem>
            ))}
          </StaggerContainer>
        </div>
      </section>

      {/* Customer Support */}
      <ScaleIn>
        <section className="py-20 bg-gradient-to-br from-secondary/5 to-primary/5">
          <div className="container mx-auto px-4">
            <div className="max-w-4xl mx-auto text-center">
              <Shield className="text-secondary mx-auto mb-6" size={64} />
              <h2
                className="text-4xl md:text-5xl font-black mb-6 gradient-text"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Dedicated Customer Support
              </h2>
              <p
                className="text-xl text-gray-700 mb-8"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Our service desk operates 8 hours a day, 6 days a week to ensure
                your business runs smoothly
              </p>
              <div className="glass-white p-8 rounded-2xl inline-block">
                <div className="flex items-center gap-4 justify-center flex-wrap">
                  <div className="flex items-center gap-2">
                    <div className="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                    <span
                      className="font-bold text-primary"
                      style={{ fontFamily: "Poppins, sans-serif" }}
                    >
                      8/6 Support Available
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </ScaleIn>

      {/* CTA Section */}
      <FadeIn>
        <section className="py-20">
          <div className="container mx-auto px-4">
            <div className="glass-card p-12 rounded-3xl text-center max-w-4xl mx-auto">
              <h2
                className="text-4xl md:text-5xl font-black mb-6 gradient-text"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Ready to Transform Your Business?
              </h2>
              <p
                className="text-xl text-gray-700 mb-8"
                style={{ fontFamily: "Inter, sans-serif" }}
              >
                Let&apos;s discuss how we can help you achieve your technology
                goals
              </p>
              <Link
                href="/contact"
                className="inline-flex items-center gap-3 bg-gradient-to-r from-secondary to-secondary-light text-white px-10 py-5 rounded-xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                <span>Get in Touch</span>
                <Sparkles size={24} />
              </Link>
            </div>
          </div>
        </section>
      </FadeIn>
    </div>
  );
}
