import React from "react";
import { ArrowRight, Zap } from "lucide-react";
import { productCategories } from "@/data/productCategoriesData";
import Link from "next/link";
const ProductsAndSolutionsSection = () => {
  return (
    <section className="py-20 relative">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6 border border-primary/20">
            <Zap size={20} className="text-primary" />
            <span
              className="text-primary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Our Solutions
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black mb-6 gradient-text"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Products & Solutions
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Comprehensive range of security and identification products
          </p>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
          {productCategories.map((category, index) => (
            <Link key={index} href={category.link} className="group relative">
              <div
                className={`absolute -inset-0.5 bg-gradient-to-r ${category.color} rounded-3xl blur opacity-0 group-hover:opacity-30 transition duration-500`}
              ></div>
              <div className="relative glass-white p-8 rounded-3xl hover:shadow-2xl transition-all transform group-hover:-translate-y-2">
                <div
                  className={`w-20 h-20 rounded-2xl bg-gradient-to-br ${category.color} flex items-center justify-center mb-6 group-hover:scale-110 group-hover:rotate-6 transition-all shadow-xl`}
                >
                  <category.icon className="text-white" size={36} />
                </div>
                <h3
                  className="text-2xl font-bold text-gray-800 mb-3 group-hover:text-primary transition-colors"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  {category.name}
                </h3>
                <p className="text-gray-600 mb-6">{category.description}</p>
                <span className="inline-flex items-center gap-2 text-secondary font-bold group-hover:gap-3 transition-all">
                  Explore <ArrowRight size={18} />
                </span>
              </div>
            </Link>
          ))}
        </div>
      </div>
    </section>
  );
};

export default ProductsAndSolutionsSection;
