import React from "react";
import { featuredProducts } from '@/queries/productQueries';
import ProductCardV2 from '@/components/ProductCard';
import Link from 'next/link';

import { Sparkles, ArrowRight } from 'lucide-react';
const LatestProductsSection = () => {
  return (
    <section className="py-20 relative">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center mb-16">
          <div>
            <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6 border border-secondary/20">
              <Sparkles size={20} className="text-secondary animate-pulse" />
              <span
                className="text-secondary font-bold"
                style={{ fontFamily: "Poppins, sans-serif" }}
              >
                Featured
              </span>
            </div>
            <h2
              className="text-4xl md:text-5xl font-black mb-4 gradient-text"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Latest Products
            </h2>
            <p className="text-xl text-gray-600">
              Discover our newest arrivals
            </p>
          </div>
          <Link
            href="/products"
            className="hidden md:flex items-center gap-2 glass-card px-6 py-3 rounded-xl font-bold text-primary hover:shadow-lg transition-all hover:scale-105 border border-primary/20"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            View All <ArrowRight size={20} />
          </Link>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
          {featuredProducts.map((product) => (
            <ProductCardV2 key={product.id} product={product} />
          ))}
        </div>
      </div>
    </section>
  );
};

export default LatestProductsSection;
