import React from "react";
import { ArrowRight, Sparkles, Zap } from "lucide-react";
import Link from "next/link";
const CTASection = () => {
  return (
    <section className="py-20 relative overflow-hidden">
      <div className="absolute inset-0 bg-gradient-to-r from-secondary via-secondary-light to-secondary"></div>
      <div className="absolute inset-0 opacity-10">
        <div className="absolute top-0 left-0 w-96 h-96 bg-white rounded-full blur-3xl"></div>
        <div className="absolute bottom-0 right-0 w-96 h-96 bg-white rounded-full blur-3xl"></div>
      </div>

      <div className="container mx-auto px-4 relative">
        <div className="max-w-4xl mx-auto text-center">
          <div className="inline-flex items-center gap-2 glass-white px-6 py-3 rounded-full mb-8">
            <Sparkles size={20} className="text-secondary animate-pulse" />
            <span
              className="text-primary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Get Started Today
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black text-white mb-8"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Ready to Upgrade Your Security?
          </h2>
          <p className="text-xl mb-10 text-white/90 leading-relaxed">
            Get a free consultation and quotation for your security needs
          </p>
          <div className="flex flex-col sm:flex-row gap-6 justify-center">
            <Link
              href="/contact"
              className="group relative inline-flex items-center justify-center gap-3 glass-white text-primary px-10 py-5 rounded-2xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105 overflow-hidden"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              <div className="absolute inset-0 bg-white translate-y-full group-hover:translate-y-0 transition-transform duration-300"></div>
              <Zap size={22} className="relative" />
              <span className="relative">Get Free Quote</span>
            </Link>
            <Link
              href="/products"
              className="group inline-flex items-center justify-center gap-3 glass-dark text-white px-10 py-5 rounded-2xl font-bold text-lg hover:shadow-2xl transition-all hover:scale-105 border-2 border-white/30"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              <span>Browse Products</span>
              <ArrowRight
                size={22}
                className="group-hover:translate-x-1 transition-transform"
              />
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CTASection;
