import React from "react";
import Image from "next/image";

import { brands } from "@/data/brandData";
import { Star } from "lucide-react";

const BrandsSection = () => {
  return (
    <section className="py-20 bg-gradient-to-br from-gray-50 to-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6 border border-primary/20">
            <Star size={20} className="text-secondary" />
            <span
              className="text-primary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Trusted Partners
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black mb-6 gradient-text"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Industry-Leading Brands
          </h2>
          <p className="text-xl text-gray-600">
            We partner with the world's best
          </p>
        </div>

        <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
          {brands.map((brand, index) => (
            <div key={index} className="group relative">
              <div className="absolute -inset-0.5 bg-gradient-to-r from-primary to-secondary rounded-2xl blur opacity-0 group-hover:opacity-30 transition duration-500"></div>
              <div className="relative glass-white p-6 rounded-2xl flex flex-col items-center justify-center hover:shadow-xl transition-all transform hover:scale-105 h-40 group">
                <div className="mb-3">
                  <Image
                    src={brand.logo}
                    alt={brand.name}
                    width={120}
                    height={80}
                    className="max-w-full h-16 object-contain grayscale group-hover:grayscale-0 transition-all"
                  />
                </div>
                <h3 className="text-sm font-medium text-gray-700 text-center group-hover:opacity-0 transition-opacity">
                  {brand.name}
                </h3>
                <div className="absolute bottom-4 left-1/2 transform -translate-x-1/2 opacity-0 group-hover:opacity-100 transition-opacity duration-300 bg-white/90 backdrop-blur-sm text-xs text-gray-600 px-3 py-1.5 rounded-full whitespace-nowrap">
                  {brand.title}
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default BrandsSection;
