import React from "react";

import { MapPin, Phone, Mail } from "lucide-react";
import { branches } from "@/lib/navigation";
function BranchesSection() {
  return (
    <section className="py-20 bg-gradient-to-br from-gray-50 to-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6 border border-secondary/20">
            <MapPin size={20} className="text-secondary" />
            <span
              className="text-secondary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Locations
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black mb-6 gradient-text"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Our Branches
          </h2>
          <p className="text-xl text-gray-600">
            Visit us at any of our locations
          </p>
        </div>

        <div
          className={`grid gap-8 ${
            branches.length === 1
              ? "grid-cols-1 justify-items-center"
              : "grid-cols-1 md:grid-cols-3"
          }`}
        >
          <div
            className={`grid gap-8 ${
              branches.length === 1
                ? "grid-cols-1 justify-items-center"
                : "grid-cols-1 md:grid-cols-3"
            }`}
          >
            {branches.map((branch, index) => (
              <div key={index} className="group relative w-full md:w-auto">
                {/* Glowing hover border */}
                <div className="absolute -inset-0.5 bg-gradient-to-r from-primary to-secondary rounded-3xl blur opacity-0 group-hover:opacity-30 transition duration-500"></div>

                {/* Card body */}
                <div className="relative glass-white p-8 rounded-3xl hover:shadow-2xl transition-all text-center flex flex-col items-center">
                  {/* Icon */}
                  <div className="bg-gradient-to-br from-primary to-primary-light w-16 h-16 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform shadow-lg">
                    <MapPin className="text-white" size={28} />
                  </div>

                  {/* Title */}
                  <h3
                    className="text-2xl font-bold text-gray-800 mb-6"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    {branch.name}
                  </h3>

                  {/* Contact info */}
                  <div className="space-y-4 text-sm w-full">
                    <div className="flex items-start gap-3 glass-card p-3 rounded-xl border border-gray-200">
                      <MapPin
                        size={16}
                        className="text-secondary mt-1 flex-shrink-0"
                      />
                      <span className="text-gray-600 text-left">
                        {branch.address}
                      </span>
                    </div>

                    <div className="flex items-center gap-3 glass-card p-3 rounded-xl border border-gray-200">
                      <Phone
                        size={16}
                        className="text-secondary flex-shrink-0"
                      />
                      <a
                        href={`tel:${branch.phone}`}
                        className="text-gray-600 hover:text-primary transition-colors font-medium text-left"
                      >
                        {branch.phone}
                      </a>
                    </div>

                    <div className="flex items-center gap-3 glass-card p-3 rounded-xl border border-gray-200">
                      <Mail
                        size={16}
                        className="text-secondary flex-shrink-0"
                      />
                      <a
                        href={`mailto:${branch.email}`}
                        className="text-gray-600 hover:text-primary transition-colors font-medium text-left"
                      >
                        {branch.email}
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}

export default BranchesSection;
