import React from "react";
import { blogPosts } from '@/data/blogData';
import Link from "next/link";
import { ArrowRight,Sparkles } from "lucide-react";

const BlogsAndNewsSection = () => {
  return (
    <section className="py-20 bg-gradient-to-br from-white via-gray-50 to-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6 border border-primary/20">
            <Sparkles size={20} className="text-primary animate-pulse" />
            <span
              className="text-primary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              Insights
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black mb-4 gradient-text"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Blog & News
          </h2>
          <p className="text-xl text-gray-600">
            Stay updated with latest insights
          </p>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
          {blogPosts.map((post) => (
            <article key={post.id} className="group relative">
              <div className="absolute -inset-0.5 bg-gradient-to-r from-primary to-secondary rounded-3xl blur opacity-0 group-hover:opacity-30 transition duration-500"></div>
              <div className="relative glass-white rounded-3xl overflow-hidden hover:shadow-2xl transition-all">
                <div className="relative h-56 overflow-hidden">
                  <img
                    src={post.image}
                    alt={post.title}
                    className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                  <div className="absolute top-4 left-4 glass-dark px-4 py-2 rounded-full">
                    <span
                      className="text-white text-xs font-bold"
                      style={{ fontFamily: "Poppins, sans-serif" }}
                    >
                      {post.category}
                    </span>
                  </div>
                </div>
                <div className="p-6">
                  <p className="text-xs text-gray-500 mb-3 font-semibold">
                    {post.date}
                  </p>
                  <h3
                    className="text-lg font-bold text-gray-800 mb-2 line-clamp-2 group-hover:text-primary transition-colors"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    {post.title}
                  </h3>
                  <p className="text-gray-600 text-sm mb-4 line-clamp-2">
                    {post.excerpt}
                  </p>
                  <Link
                    href={`/blog/${post.slug}`}
                    className="inline-flex items-center gap-1 text-secondary font-bold text-sm hover:gap-2 transition-all"
                  >
                    Read More <ArrowRight size={16} />
                  </Link>
                </div>
              </div>
            </article>
          ))}
        </div>
      </div>
    </section>
  );
};

export default BlogsAndNewsSection;
