import React from "react";
import { Sparkles, Building2, Award, Users, Shield, Lightbulb } from "lucide-react";
const AboutUsSection = () => {
  return (
    <section className="py-20 relative overflow-hidden">
      <div className="absolute inset-0 bg-gradient-to-br from-gray-50 via-white to-gray-50"></div>
      <div className="container mx-auto px-4 relative">
        <div className="max-w-4xl mx-auto">
          <div className="inline-flex items-center gap-2 glass-card px-6 py-3 rounded-full mb-6">
            <Sparkles size={20} className="text-secondary animate-pulse" />
            <span
              className="text-primary font-bold"
              style={{ fontFamily: "Poppins, sans-serif" }}
            >
              About Us
            </span>
          </div>
          <h2
            className="text-4xl md:text-5xl font-black mb-6 gradient-text"
            style={{ fontFamily: "Poppins, sans-serif" }}
          >
            Who We Are
          </h2>
          <div className="space-y-8">
            <p
              className="text-lg leading-relaxed text-gray-700"
              style={{ fontFamily: "Inter, sans-serif" }}
            >
              <strong className="text-primary">Intelligent Technology</strong>{" "}
              is a pioneering company in Bangladesh specializing in{" "}
              <strong>
                Card Printing, Office Automation & Security Solutions
              </strong>
              . We provide cutting-edge technology solutions to businesses
              across various sectors.
            </p>

            <div className="grid md:grid-cols-2 gap-6">
              {/* Company Info */}
              <div className="glass-card p-6 rounded-2xl space-y-5">
                <h3
                  className="text-xl font-bold text-primary mb-4 flex items-center gap-2"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  <Building2 className="text-secondary" size={24} />
                  Company Information
                </h3>
                <div className="space-y-4">
                  <div className="flex items-start gap-3">
                    <div className="bg-primary/10 p-2 rounded-lg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-primary"
                      >
                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                      </svg>
                    </div>
                    <div>
                      <p className="font-semibold text-primary">
                        Authorized Distributor
                      </p>
                      <p className="text-gray-700">
                        HiTi Digital Inc. (Taiwan)
                      </p>
                    </div>
                  </div>

                  <div className="flex items-start gap-3">
                    <div className="bg-primary/10 p-2 rounded-lg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-primary"
                      >
                        <rect
                          x="3"
                          y="3"
                          width="18"
                          height="18"
                          rx="2"
                          ry="2"
                        ></rect>
                        <path d="M3 9h18"></path>
                        <path d="M9 21V9"></path>
                      </svg>
                    </div>
                    <div>
                      <p className="font-semibold text-primary">Reseller</p>
                      <p className="text-gray-700">Zebra Technologies (USA)</p>
                      <p className="text-gray-700">
                        Evolis Card Printers (France)
                      </p>
                    </div>
                  </div>

                  <div className="flex items-start gap-3">
                    <div className="bg-primary/10 p-2 rounded-lg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-primary"
                      >
                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                      </svg>
                    </div>
                    <div>
                      <p className="font-semibold text-primary">License</p>
                      <p className="text-gray-700">Class-One Contractor</p>
                      <p className="text-gray-700">e-GP Enlisted</p>
                      <p className="text-gray-700">
                        Electrical Supervisory License
                      </p>
                    </div>
                  </div>
                </div>
              </div>

              {/* Contact & Support */}
              <div className="glass-card p-6 rounded-2xl space-y-5">
                <h3
                  className="text-xl font-bold text-primary mb-4 flex items-center gap-2"
                  style={{ fontFamily: "Poppins, sans-serif" }}
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    className="text-secondary"
                  >
                    <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                  </svg>
                  Contact & Support
                </h3>
                <div className="space-y-4">
                  <div className="flex items-center gap-3 p-3 bg-white/50 rounded-lg">
                    <div className="bg-secondary/10 p-2 rounded-lg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-secondary"
                      >
                        <circle cx="12" cy="12" r="10"></circle>
                        <polyline points="12 6 12 12 16 14"></polyline>
                      </svg>
                    </div>
                    <div>
                      <p className="font-semibold text-primary">
                        Service Hours
                      </p>
                      <p className="text-gray-700">
                        8:00 AM - 5:00 PM (Sat - Thu)
                      </p>
                    </div>
                  </div>

                  <div className="flex items-center gap-3 p-3 bg-white/50 rounded-lg">
                    <div className="bg-secondary/10 p-2 rounded-lg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        className="text-secondary"
                      >
                        <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                        <circle cx="12" cy="10" r="3"></circle>
                      </svg>
                    </div>
                    <div>
                      <p className="font-semibold text-primary">Address</p>
                      <p className="text-gray-700">
                        House #7 (3rd Floor), Road #4
                      </p>
                      <p className="text-gray-700">
                        Mirpur-10, Dhaka-1216, Bangladesh
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            {/* Stats */}
            <div className="grid grid-cols-2 md:grid-cols-4 gap-4 mt-6">
              {[
                {
                  icon: <Award size={24} className="text-secondary" />,
                  value: "5+",
                  label: "Years Experience",
                },
                {
                  icon: <Users size={24} className="text-primary" />,
                  value: "50+",
                  label: "Happy Clients",
                },
                {
                  icon: <Shield size={24} className="text-secondary" />,
                  value: "24/7",
                  label: "Support",
                },
                {
                  icon: <Lightbulb size={24} className="text-primary" />,
                  value: "100%",
                  label: "Quality",
                },
              ].map((stat, index) => (
                <div
                  key={index}
                  className="glass-card p-4 rounded-2xl text-center hover:shadow-xl transition-all hover:scale-105"
                >
                  <div className="w-12 h-12 flex items-center justify-center bg-primary/10 rounded-full mx-auto mb-2">
                    {stat.icon}
                  </div>
                  <h3
                    className="text-2xl font-bold text-primary mb-1"
                    style={{ fontFamily: "Poppins, sans-serif" }}
                  >
                    {stat.value}
                  </h3>
                  <p
                    className="text-sm text-gray-600"
                    style={{ fontFamily: "Inter, sans-serif" }}
                  >
                    {stat.label}
                  </p>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default AboutUsSection;
